jQuery(document).ready(function ($) {
    $(".menu-icon").click(function(){
        $(".menu-main-menu-container").show();
        $(".close-icon").show();
        $(this).hide();
    });

    $(".close-icon").click(function(){
        $(".menu-main-menu-container").hide();
        $(".menu-icon").show();
        $(this).hide();
    });

    $(".menu-item").hover(function(){
        if($(window).width() > 768) {
            $(this).find(".sub-menu").show();
        }
    }, function(){
        if($(window).width() > 768) {
            $(this).find(".sub-menu").hide();
        }
    });

    $(".menu-item a").click(function(e){
        if($(window).width() <= 768){
            var submenu = $(this).parent().find(".sub-menu");
            if(submenu.length > 0 && $(this).attr("href") == "#"){
                e.preventDefault();
                submenu.toggle();
            }
        }
    });

    $('.scroll-down-arrow').click(function(){
        var offset = 20;
        var next_section = $(this).parents('article').next('article');

        $('html, body').animate({
            scrollTop: next_section.offset().top + offset
        }, 500);
    });

    $('.home-slider').slick({
        autoplay: true,
        speed: 1000,
        autoplaySpeed: 2000,
        fade: true
    });

    $(".about_us_section h2").prepend('<div class="leftBracket"></div>').append('<div class="rightBracket"></div>');

    $(".gallery").each(function(){
        var html = $(this).html();
        $(this).html('<div class="gallery_container">' + html + '</div>');
    });

    $(".gform_button_select_files").attr("value", "UPLOAD");

    if(navigator.userAgent.indexOf("Safari") > -1 && navigator.userAgent.indexOf("Chrome") == -1){
        $('body').addClass('mac-os');
    }
    else if(navigator.userAgent.match(/Macintosh/) && navigator.userAgent.match(/Chrome/)){
        $('body').addClass('mac-os');
    }

    $(window).resize(function(){
        /*if($(window).width() > 768) {
            $(".about_us_section > img").css("margin-top", $(".about_us_section h2").outerHeight(true));
        }
        else{
            $(".about_us_section > img").css("margin-top", 0);
        }*/

        // $('.home_section').css('max-height', $(window).height());        
        if($(window).width() >= 768){
            $('.home .home-slider .slick-track, .home .home_section').height($(window).height() + 500);
        } else {
            $('.home .home-slider .slick-track, .home .home_section').height($(window).height());
        }
        if($(window).width() <= 768){
            $('.home-slider img').width($(window).width());
        }
    }).resize();
});