<?php get_header(); ?>
<?php
$displayCategory = types_render_field("display-category", array("output" => "raw"));
if (!empty($displayCategory)) {
    $args = array(
        'post_type' => array('section'),
        'category_name' => $displayCategory,
        'order' => 'ASC'
    );
    $query = new WP_Query($args);
    ?>
    <section id="content" role="main">
        <?php if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
            <?php
            $sectionType = types_render_field("section-type", array("output" => "raw"));
            get_template_part("section", $sectionType);
            ?>
        <?php endwhile; endif; ?>
    </section>
    <?php
} else {
    ?>
    <section id="content" role="main">

        <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            <?php
            if (has_post_thumbnail()) {
                ?>
                <article id="post-home-<?php the_ID(); ?>" <?php post_class("home_section"); ?>>
                    <?php the_post_thumbnail("background"); ?>
                    <header class="header center_text">
                        <h2 class="entry-title"><?php the_title(); ?></h2>
                    </header>

                </article>
                <?php
            } else {
                ?>
                <div id="header_back"></div>
                <?php
            }
            ?>
            <div class="wrapper">
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php
                    if (!has_post_thumbnail()) {
                        ?>
                        <header class="header">
                            <h1 class="entry-title"><?php the_title(); ?></h1>
                        </header>
                        <?php
                    }
                    ?>
                    <section class="entry-content">

                        <?php the_content(); ?>
                    </section>
                </article>
            </div>

        <?php endwhile; endif; ?>
    </section>
    <?php
}

get_footer(); ?>