<article id="post-<?php the_ID(); ?>" <?php post_class("testimonials_section"); ?>>
    <header>
        <h2><?php the_title(); ?></h2>
    </header>
    <div class="content">
        <?php

        $args = array(
            'post_type' => array('testimonial'),
            'order' => 'ASC'
        );
        $query = new WP_Query($args);
        if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post(); ?>
            <?php
            $rating = types_render_field("rating", array("output" => "raw"));
            $image = types_render_field("person-image", array("output" => "raw"));
            ?>
            <div class="paragraph">
                <div class="image">
                    <img src="<?php echo $image;?>" alt="">
                </div>

                <div class="text">
                    <div class="leftBracket"></div>
                    <?php the_content();?>
                    <div class="rightBracket"></div>
                </div>

                <div class="name">
                    <?php the_title(); ?>
                    <span>
                        <?php
                        for($i = 1; $i <= 5; $i++){
                            if($rating > $i){
                                ?>
                                <img src="<?php echo get_template_directory_uri();?>/images/star1.png" alt="">
                                <?php
                            }
                            else if($rating < $i && $rating + 1 > $i){
                                ?>
                                <img src="<?php echo get_template_directory_uri();?>/images/star2.png" alt="">
                                <?php
                            }
                            else{
                                ?>
                                <img src="<?php echo get_template_directory_uri();?>/images/star3.png" alt="">
                                <?php
                            }
                        }
                        ?>
                    </span>
                </div>
            </div>
        <?php endwhile; endif; ?>
        <?php wp_reset_postdata(); ?>
    </div>
    <div class="clear"></div>
</article>